<?php $__env->startSection("title", "Cart"); ?>
<?php $__env->startSection('content'); ?>

<div id="wrapper">

    <section class="yt-bg-player yt-cart" >
        <div class="bg-transparent ">
            <!-- Slider content -->
            <div class="container dark slider-content"> <i class="icon-top-draw"></i>
                <div id="text-transform" class="owl-carousel">
                    <div class="item">
                        <h1>Cart</h1>
                    </div>
                </div>
                <p class="text-capitalize">An Oasis Of Pleasure</p>
                <i class="icon-bottom-draw"></i>
            </div>
            <!-- End Slider content -->
        </div>
        <!-- End Bg transparent -->
    </section>
    <?php echo $__env->make('layouts.includes.main-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <div id="content">
    <?php echo $__env->make('layouts.includes.main-nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Carts
    ============================================= -->
    <section class="carts text-center padding-100">
        <div class="container">
          <div class="row">
            <div class="col-md-12">
              <!-- Table carts -->
              <table class="table table-striped table-responsive table-cart">

                <thead>
                  <tr>
                    <th style="width:40%">Meal</th>
                    <th style="width:15%">Price</th>
                    <th style="width:20%">Quantity</th>
                    <th style="width:25%">Total</th>
                  </tr>
                </thead>
                <tbody>
                    <?php $total = 0.00; ?>
                    <?php if(count($cart) == 0): ?>
                        <tr>
                        <td colspan="4"><p class="text-center"> Cart is Empty</p></td>
                        </tr>
                    <?php else: ?>
                        <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><a href="#"><img src="/storage/img/<?php echo e($row['photo']); ?>" alt=""><?php echo e($row['name']); ?></a> </td>
                                <td>&#8358; <?php echo e(number_format($row['price'], 2)); ?></td>
                                <td><!-- input group minus & plus-->
                                <div class="input-group plus-minus"> <span class="input-group-btn">
                                    <button type="button" class="btn btn-default btn-number <?php if($row['quantity'] > 1): ?> decreaseQty <?php endif; ?> " <?php if($row['quantity'] <= 1): ?> disabled <?php endif; ?>  data-id="<?php echo e($row['id']); ?>"> <span class="fa fa-minus"></span> </button>
                                    </span>
                                    <input type="number" name="quantity" class="form-control input-number qtyValue" min="1" max="10" value="<?php echo e($row['quantity']); ?>" readonly>
                                    <span class="input-group-btn">
                                    <button type="button" class="btn btn-default btn-number increaseQty" data-id="<?php echo e($row['id']); ?>"> <span class="fa fa-plus"></span> </button>
                                    </span> </div>
                                <!-- End input group minus & plus --></td>
                                <td><span class="total">&#8358;<?php echo e(number_format(floatval($row['price']) * intval($row['quantity']), 2)); ?></span> <button type="submit" class="pull-right btn btn-danger removeFromCart" data-id="<?php echo e($row['id']); ?>"><i class="fa fa-times"></i></button></td>
                            </tr>
                            <?php
                                $total += floatval($row['price']) * intval($row['quantity']);
                            ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    </tbody>
              </table>
              <!-- End Table carts  -->
            </div>
            <!-- Carts content -->
            <div class="col-md-12 carts-content">
              <div class="row">
                <!-- Left side -->
                <div class="col-md-5 left-side">
                  <form class="form-inline">
                     <div class="form-group">
                      <input type="text" class="form-control" placeholder="Coupon Code">
                    </div>
                    <button type="submit" class="btn btn-black">Apply</button>
                  </form>

                </div>
                <!-- End Left side -->
                <!-- Right side -->
                <?php if(count($cart) != 0): ?>
                <div class="col-md-7 right-side">
                <!-- Carts total -->
                  <div class="carts-total text-left">
                    <h3>Carts Total</h3>
                    <table class="table table-bordered">
                      <tbody>
                        <tr>
                          <td>Order Total</td>
                          <td>₦ <?php echo e(number_format($total,2)); ?></td>
                        </tr>
                      </tbody>
                    </table>
                  </div>
                  <!-- Carts total -->
                  <div class="form-group text-right checkout" style="margin-top:20px;">
                  <a href="<?php echo e(route('checkout')); ?>" class="btn  btn-black">PROCEED TO CHECKOUT</a>
                  </div>
                  <!-- Carts total -->
                </div>
                <?php endif; ?>
                <!--End Right side -->
              </div>
            </div>
            <!--End Carts content -->
          </div>
        </div>
      </section>
      <!-- End Carts -->
  </div>
  <!-- end of #content -->
</div>

<script src="javascripts/libs/jquery.min.js" type="text/javascript"></script>
<?php echo toastr_js(); ?>
<script>

toastr.options = {
  "closeButton": true,
  "debug": false,
  "newestOnTop": false,
  "progressBar": true,
  "positionClass": "toast-top-right",
  "preventDuplicates": true,
  "onclick": null,
  "showDuration": "300",
  "hideDuration": "1000",
  "timeOut": "5000",
  "extendedTimeOut": "1000",
  "showEasing": "swing",
  "hideEasing": "linear",
  "showMethod": "fadeIn",
  "hideMethod": "fadeOut"
}

  function refreshPage() {
    location.reload(true);
}
    const BASE_URL = "<?php echo e(url('/')); ?>";
    const REQUEST_URL = "<?=Request::url()?>";
    let CSRF = "<?php echo e(csrf_token()); ?>";


    $('.removeFromCart').on("click", function(){
        var id = $(this).attr("data-id");
        var data = new FormData();
        data.append('id', id);

        $.ajax({
          url: BASE_URL + '/remove-from-cart/'+ id,
          type: "GET",
          timeout: 5000,
          data: data,
          contentType: false,
          cache: false,
          processData: false,
          headers: {'X-CSRF-TOKEN': CSRF},
          success: function(response){
            toastr.success('Item removed from cart');
            setInterval('refreshPage()', 5000);
          },
          error: function(){
            alert("Oops, there was an error, try again later");
          }
      });
    });

    $('.increaseQty').on("click", function(e){
        e.preventDefault();
        var _this = $(this);
        var id = _this.attr("data-id");
        var data = new FormData();
        data.append('id', id);
        $.ajax({
            url: BASE_URL + '/add-to-cart/'+ id,
            type: "GET",
            timeout: 5000,
            data: data,
            contentType: false,
            cache: false,
            processData: false,
            headers: {'X-CSRF-TOKEN': CSRF},
            success: function(response){
                toastr.success('Cart Updated');
                refreshPage();
            },
            error: function(){
                alert("Oops, there was an error, try again later");
            }
        });
    });
    $('.decreaseQty').on("click", function(e){
        e.preventDefault();
        var _this = $(this);
        var id = _this.attr("data-id");
        var data = new FormData();
        data.append('id', id);
        $.ajax({
            url: BASE_URL + '/sub-qty/'+ id,
            type: "PATCH",
            timeout: 5000,
            data: data,
            contentType: false,
            cache: false,
            processData: false,
            headers: {'X-CSRF-TOKEN': CSRF},
            success: function(response){
                toastr.success('Cart Updated');
                refreshPage();
            },
            error: function(){
                alert("Oops, there was an error, try again later");
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\laravel\landnkitchen\resources\views/cart.blade.php ENDPATH**/ ?>