<?php
    $product = App\Models\Product::find($order->product_id);
?>
<table class="table">
      <tr>
        <th scope="col">Order Id</th>
        <td><?php echo e($order->order_id); ?></td>
      </tr>
      <tr>
        <th scope="col">Product Name</th>
        <td><?php echo e($product->name); ?></td>
      </tr>
      <tr>
        <th scope="col">Full Name</th>
        <td><?php echo e($order->fullname); ?></td>
      </tr>
      <tr>
        <th scope="col">Email</th>
        <td><?php echo e($order->email); ?></td>
      </tr>
      <tr>
        <th scope="col">Phone</th>
        <td><?php echo e($order->phone); ?></td>
      </tr>
      <tr>
        <th scope="col">Address</th>
        <td><?php echo e($order->address); ?></td>
      </tr>
      <tr>
        <th scope="col">Quantity</th>
        <td><?php echo e($order->quantity); ?></td>
      </tr>
      <tr>
        <th scope="col">Price</th>
        <td>&#8358; <?php echo e(number_format($order->price, 2)); ?></td>
      </tr>
      <tr>
        <th scope="col">Subtotal</th>
        <td>&#8358; <?php echo e(number_format($order->subtotal, 2)); ?></td>
      </tr>
      <tr>
        <th scope="col">Total</th>
        <td>&#8358; <?php echo e(number_format($order->total, 2)); ?></td>
      </tr>
      <tr>
        <th scope="col">Type</th>
        <td><?php echo e($order->type); ?></td>
      </tr>
      <tr>
        <th scope="col">Payment status</th>
        <td><span class="badge badge-success"><?php echo e($order->payment_status); ?></span></td>
      </tr>
      <tr>
        <th scope="col">Sale status</th>
        <td><span class="badge badge-warning"><?php echo e($order->sale_status); ?></span></td>
      </tr>
      <tr>
        <th scope="col">Date</th>
        <td><?php echo e($order->date); ?></td>
      </tr>
      <tr>
        <th scope="col">Time</th>
        <td><?php echo e($order->time); ?></td>
      </tr>
      <tr>
        <th scope="col">Instructions</th>
        <td><?php echo e($order->instructions); ?></td>
      </tr>
  </table>
<?php /**PATH C:\xampp\htdocs\laravel\landnkitchen\resources\views/modals/order/view.blade.php ENDPATH**/ ?>