@extends("layouts.admin")
@section("title", "Manage Orders")
@section('content')

<div class="container-fluid">
    <!-- Page-Title -->
    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <div class="row">
                    <div class="col">
                        <h4 class="page-title">Orders</h4>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Landnkitchen</a></li>
                            <li class="breadcrumb-item active">Orders</li>
                        </ol>
                    </div><!--end col-->
                </div><!--end row-->
            </div><!--end page-title-box-->
        </div><!--end col-->
    </div><!--end row-->
    <!-- end page title end breadcrumb -->
    <div class="row">
        <div class="col-12">
            @if (Session::has('error'))
                <div class="alert alert-danger" role="alert">
                    {{ Session::get('error') }}
                </div>
            @endif
            @if (Session::has('success'))
                <div class="alert alert-success" role="alert">
                    {{ Session::get('success') }}
                </div>
            @endif
            <div class="table-responsive">
                <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                    <thead>
                    <tr>
                        <th>SN</th>
                        <th>Order ID</th>
                        <th>Product</th>
                        <th>Full name</th>
                        <th>Phone</th>
                        <th>Total</th>
                        <th>Type</th>
                        <th>Payment Status</th>
                        <th>Sale Status</th>
                        <th>Date</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                        @php $sn = 1 @endphp
                        @foreach ( $orders as $order )
                        @php
                            $product = App\Models\Product::find($order->product_id);
                        @endphp
                        <tr>
                            <td>{{ $sn }}</td>
                            <td>{{ $order->order_id }}</td>
                            <td>{{ $product->name }}</td>
                            <td>{{ $order->fullname }}</td>
                            <td>{{ $order->phone }}</td>
                            <td>&#8358; {{ number_format($order->total, 2) }}</td>
                            <td>{{ $order->type }}</td>
                            <td><span class="badge badge-success">{{ $order->payment_status }}</span></td>
                            <td><span class="badge badge-warning">{{ $order->sale_status }}</span></td>
                            <td>{{ $order->created_at->diffForHumans() }}</td>
                            <td>
                                <a href="javascript:void(0)" class="js_view_order" data-toggle="modal" data-target="#viewModal" data-id="{{ $order->id }}"><i class="las la-eye text-info font-18"></i></a>
                                <a href="javascript:void(0)" class="js_delete_order" data-toggle="modal" data-target="#deleteModal" data-id="{{ $order->id }}"><i class="las la-trash-alt text-danger font-18"></i></a>
                            </td>
                        </tr>
                        @php $sn ++ @endphp
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->

</div><!-- container -->

  <!-- Delete Modal -->
  <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalTitle" aria-hidden="true">
    <form action="{{ route("delete.order") }}" method="POST">
        <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
            <h5 class="modal-title" id="deleteModalTitle">Delete Order</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            </div>
            <div class="modal-body" id="js_replace_delete_content">
            </div>
            <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">No</button>
            <button type="submit" class="btn btn-primary">Yes</button>
            </div>
        </div>
        </div>
    </form>
  </div>
  <div class="modal fade" id="viewModal" tabindex="-1" role="dialog" aria-labelledby="viewModalTitle" aria-hidden="true">
    <form action="" method="POST">
        <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
            <h5 class="modal-title" id="deleteModalTitle">Order</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            </div>
            <div class="modal-body" id="js_replace_view_content">
            </div>
            <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">close</button>
            </div>
        </div>
        </div>
    </form>
  </div>
  <script src="{{ asset("js/jquery.min.js") }}"></script>
  <script>
        $(document).ready(function(){
            var loader = `<div class="text-center">
                            <i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i>
                        </div>`;

            const BASE_URL = "{{ url('/') }}";
            const REQUEST_URL = "<?=Request::url()?>";
            let CSRF = "{{ csrf_token() }}";

            $('body').on("click", '.js_delete_order', function(e){
                $('#js_replace_delete_content').html(loader);
                const id = $(this).attr("data-id");
                var data = new FormData();
                data.append('id', id);

                $.ajax({
                    url: BASE_URL + '/admin/delete-order/' + id,
                    method: "GET",
                    timeout: 5000,
                    data: data,
                    contentType: false,
                    cache: false,
                    processData: false,
                    headers: {'X-CSRF-TOKEN': CSRF},
                    success: function(response){
                        $('#js_replace_delete_content').html(response.html);
                    },
                    error: function(err){
                        alert("Oops, there was an error, try again later");
                    }
                })
            })

            $('body').on("click", '.js_view_order', function(e){
                $('#js_replace_view_content').html(loader);
                const id = $(this).attr("data-id");
                var data = new FormData();
                data.append('id', id);

                $.ajax({
                    url: BASE_URL + '/admin/view-order/' + id,
                    method: "GET",
                    timeout: 5000,
                    data: data,
                    contentType: false,
                    cache: false,
                    processData: false,
                    headers: {'X-CSRF-TOKEN': CSRF},
                    success: function(response){
                        $('#js_replace_view_content').html(response.html);
                    },
                    error: function(err){
                        alert("Oops, there was an error, try again later");
                    }
                })
            })
        });

  </script>
@endsection
