<?php

namespace App\Http\Controllers;

use App\Mail\ContactAdminMail;
use App\Mail\ContactMail;
use Exception;
use App\Models\Contact;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ContactController extends Controller
{
    //
    public function index(){
        return view('contact');
    }

    public function sendMessage(Request $request){
        //validate
        $request->validate([
            'name' => 'required',
            'email' => ["required", "email"],
            'message' => 'required',
            'subject' => 'required',
            'g-recaptcha-response' => 'required|recaptcha',
        ]);

        try {
            Contact::create([
                "name" => $request->name,
                "email" => $request->email,
                "message" => $request->message,
                "subject" => $request->subject,
            ]);
            //mail -- to customer
            Mail::to($request->email)->send(new ContactMail([
                "name" => $request->name,
                "email" => $request->email,
                "message" => $request->message,
                "subject" => $request->subject,
            ]));
            //mail -- to admin
            Mail::to("info@landnkitchen.com")->send(new ContactAdminMail([
                "name" => $request->name,
                "email" => $request->email,
                "message" => $request->message,
                "subject" => $request->subject,
            ]));

            return redirect()->back()->with("success", "Thank you, we have recevied your message, you shall be contacted shortly");
        } catch (Exception $e) {
            dd($e);
            return redirect()->back()->with("error", "Oops, there was an error!!");
        }


    }
}
