<?php

namespace App\Http\Controllers;

use App\Models\Delivery;
use App\Models\Location;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class CheckoutController extends Controller
{
    //
    public function index(){
        $locations = Location::get();
        if(!Session::has('_cart')){
            $cart = [];
        }else{
            //check if it empty
            $cookie_data = stripcslashes(session("_cart"));
            $cart = json_decode($cookie_data, true);

        }
        return view("checkout")->with(['locations' => $locations, "cart" => $cart]);
    }

    public function checkout(Request $request){

        if($request->type == 'dine_in'){
            $type = $request->type;
            $dinein_date = $request->arrival_date;
            $dinein_time = $request->arrival_time;
            $instructions = $request->instructions;
            $address = '1st Avenue, beside Total Filling Station, Gwarinpa Estate, Abuja';

            session()->put('type', $type);
            session()->put('date', $dinein_date);
            session()->put('time', $dinein_time);
            session()->put('instructions', $instructions);
            session()->put('deliveryaddress', $address);
        }elseif($request->type == 'pick_up'){
            $type = $request->type;
            $pickup_date = $request->pickup_date;
            $pickup_time = $request->pickup_time;
            $instructions = $request->instructions;
            $address = '1st Avenue, beside Total Filling Station, Gwarinpa Estate, Abuja';

            session()->put('takeaway', session()->get('takeaway_fee'));

            session()->put('type', $type);
            session()->put('date', $pickup_date);
            session()->put('time', $pickup_time);
            session()->put('instructions', $instructions);
            session()->put('deliveryaddress', $address);

        }elseif($request->type == 'delivery'){
            $type = $request->type;
            $del_date = $request->delivery_date;
            $del_time = $request->delivery_time;
            $instructions = $request->instructions;

            session()->put('type', $type);
            session()->put('date', $del_date);
            session()->put('time', $del_time);
            session()->put('instructions', $instructions);
            session()->put('takeaway',   session()->get('takeaway_fee'));
            $location = $request->input('location');
            $address = $request->input('address');
            $del = Location::findorFail($location);
            $cost = $del->cost;
            session()->put('location', $location);
            session()->put('deliverycost', $cost);
            session()->put('deliveryaddress', $address);
        }

        return redirect()->back()->with('success', 'Delivery details updated successfully');
    }

    public function storeGuest(Request $request){
        $this->validate($request, [
            "first_name" => "required|min:3|max:50",
            "last_name" => "required|min:3|max:50",
            "email" => "required|email",
            "address" => "required",
            "phone" => "required"
        ]);
        $user = [
            "first_name" => $request->input('first_name'),
            "last_name" => $request->input('last_name'),
            "email" => $request->input('email'),
            "address" => $request->input('address'),
            "phone" => $request->input('phone')
        ];

        session()->put('user',$user);

        return redirect()->route('payment');
    }

    public function payment(){
        if(!Session::has('_cart')){
            $cart = [];
        }else{
            //check if it empty
            $cookie_data = stripcslashes(session("_cart"));
            $cart = json_decode($cookie_data, true);

        }
        return view("payment")->with(["cart" => $cart]);
    }
}
