<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Product;
use Illuminate\Support\Facades\Session;

class CartController extends Controller
{
    //

    public function index(){
        if(!Session::has('_cart')){
            $cart = [];
        }else{
            //check if it empty
            $cookie_data = stripcslashes(session("_cart"));
            $cart = json_decode($cookie_data, true);
        }
        return view('cart', ["cart" => $cart]);
    }

    public function addToCart( $id ){
        if (session()->has('takeaway_count')) {
            $cart_count = session('takeaway_count');
        } else {
            $cart_count = 0;
        }
        if (session()->has('takeaway_fee')) {
            $takeaway_fee = session('takeaway_fee');
        } else {
            $takeaway_fee = 0;
        }
        //check if product is do not exit
        $product = Product::find($id);
        if(!$product){
            abort(404);
        }

        if(Session::has('_cart')){
            $cookie_data = stripcslashes(session("_cart"));
            $cartData = json_decode($cookie_data, true);
        }else{
            $cartData = [];
        }

        $product_id_list = array_column($cartData,"id");
        if ( in_array($id , $product_id_list) ) {
            foreach ($cartData as $key => $value) {
                if ($cartData[$key]['id'] == $id) {
                    $cartData[$key]['quantity'] = intval($cartData[$key]['quantity']) + 1;
                }
            }
        }else{
            //just add up the product to the cart
            $category = Category::find($product->category_id);
            $data = [
                "id" => $product->id,
                "name" => $product->name,
                "category" => $product->category_id,
                "quantity" => 1,
                "takeaway" => $category->takeaway,
                "price" => $product->price,
                "photo" => $product->photo,
                "vat" => $product->vat,
            ];

            $cartData[] = $data;
            if ($category->takeaway == 1) {
                $takeaway_fee += 250;
                session()->put('takeaway_count', $cart_count + 1);
                session()->put('takeaway_fee', $takeaway_fee);
            }
        }

        $json_data = json_encode($cartData);
        session(['_cart' => $json_data]);



        return redirect()->back();
    }


    public function subQty($id){
        if (session()->has('takeaway_count')) {
            $cart_count = session('takeaway_count');
        } else {
            $cart_count = 0;
        }
        if (session()->has('takeaway_fee')) {
            $takeaway_fee = session('takeaway_fee');
        } else {
            $takeaway_fee = 0;
        }

        //find the product and reduce its quantity
        if(Session::has('_cart')){
            $cookie_data = stripcslashes(session("_cart"));
            $cartData = json_decode($cookie_data, true);

            $product_id_list = array_column($cartData,"id");
            if ( in_array($id , $product_id_list) ) {
                foreach ($cartData as $key => $value) {
                    if ($cartData[$key]['id'] == $id) {
                        $cartData[$key]['quantity'] = intval($cartData[$key]['quantity']) - 1;
                        if ($cartData[$key]['takeaway'] == 1) {
                            $takeaway_fee -= 250;
                            session()->put('takeaway_count', $cart_count - 1);
                            session()->put('takeaway_fee', $takeaway_fee);
                        }
                    }
                }
                $json_data = json_encode($cartData);
                session(['_cart' => $json_data]);

            }else{
                abort(404);
            }
        }else{
            abort(404);
        }
    }

    public function fromItem( $id ){
        if (session()->has('takeaway_count')) {
            $cart_count = session('takeaway_count');
        } else {
            $cart_count = 0;
        }
        if (session()->has('takeaway_fee')) {
            $takeaway_fee = session('takeaway_fee');
        } else {
            $takeaway_fee = 0;
        }
        //check if product is do not exit
        $product = Product::find($id);
        if(!$product){
            abort(404);
        }

        $cookie_data = stripcslashes(session("_cart"));
        $cart_data = json_decode($cookie_data,true);
        foreach ($cart_data as $key => $value) {
            if ($cart_data[$key]['id'] == $id) {
                
                if ($cart_data[$key]['takeaway'] == 1) {
                    $takeaway_fee -= 250;
                    session()->put('takeaway_count', $cart_count - 1);
                    session()->put('takeaway_fee', $takeaway_fee);
                }
                unset($cart_data[$key]);
                $item_data = json_encode($cart_data);
                session(['_cart' => $item_data]);

            }
        }

        return redirect()->back();
    }
}
